﻿using System;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Activation;
using System.ServiceModel.Web;
using ServiceData.Simple;
using System.Web.UI;
using System.Web;

namespace ServiceWeb.AjaxWCFServices
{
    [ServiceContract]
    [AspNetCompatibilityRequirements(RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)]
    public class SimpleService
    {
        [OperationContract]
        public Customer SaveCustomer(Customer customer)
        {
            if (customer.CustomerId == 0)
            {
                Random random = new Random();
                customer.CustomerId = random.Next();
            }
            HttpContext.Current.Session.Add(customer.CustomerId.ToString(), customer);
            return customer;
        }

        [OperationContract]
        public Customer LookupCustomer(int customerId)
        {
            object customer = null;
            customer = HttpContext.Current.Session[customerId.ToString()];
            return customer as Customer;
        }
        
    }
}
